#include "uart.h"

xdata u8 uart_rec[REC_DATA_LEN] = 0;
u16 uart_site = 0;
u8 uart_rec_temp = 0;

bit busy;


/*----------------------------
UART interrupt service routine
----------------------------*/
void Uart_Isr() interrupt 4
{
	
    if (RI)
    {
		
        RI = 0;             //Clear receive interrupt flag
		
		
		uart_rec_temp = SBUF;
		if(uart_rec[REC_DATA_LEN-1])
		{
			return ;
		}
		if(uart_rec_temp != 0 )
		{
			uart_rec[uart_site++] = uart_rec_temp;
		}else{
			uart_rec[REC_DATA_LEN-1] = 1;
		}

    }
    if (TI)
    {
        TI = 0;             //Clear transmit interrupt flag
        busy = 0;           //Clear transmit busy flag
    }
}

/*----------------------------
Send a u8 data to UART
Input: dat (data to be sent)
Output:None
----------------------------*/
void SendData(u8 dat)
{
    while (busy);           //Wait for the completion of the previous data is sent
    ACC = dat;              //Calculate the even parity bit P (PSW.0)
    if (P)                  //Set the parity bit according to P
    {

        TB8 = 0;            //Set parity bit to 0

    }
    else
    {

        TB8 = 1;            //Set parity bit to 1

    }
    busy = 1;
    SBUF = ACC;             //Send data to UART buffer
}

/*----------------------------
Send a string to UART
Input: s (address of string)
Output:None
----------------------------*/
void SendStringByLen(char *s,u16 len)
{
	u16 i = 0;

	for(i = 0;i < len;i++)
	{
		SendData(*s++);
	}
}

void SendString(char *s)
{
    while (*s)              //Check the end of the string
    {
        SendData(*s++);     //Send current char and increment string ptr
    }
}

void UartInit(void)
{
	 SCON = 0x50;            //8-bit variable UART
    TMOD |= 0x20;            //Set Timer1 as 8-bit auto reload mode
    TH1 = TL1 = -(FOSC/12/32/BAUD); //Set auto-reload vaule
    TR1 = 1;                //Timer1 start run
    ES = 1;                 //Enable UART interrupt
    EA = 1;                 //Open master interrupt switch
}